/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftbquests.quest.task.AdvancementTask;
import dev.ftb.mods.ftbquests.quest.task.BiomeTask;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.CustomTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.StageTask;
import dev.ftb.mods.ftbquests.quest.task.StatTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.XPTask;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;

public interface TaskTypes {
    public static final Map<ResourceLocation, TaskType> TYPES = new LinkedHashMap<ResourceLocation, TaskType>();
    public static final TaskType ITEM = TaskTypes.register(new ResourceLocation("ftbquests", "item"), ItemTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond"));
    public static final TaskType CUSTOM = TaskTypes.register(new ResourceLocation("ftbquests", "custom"), CustomTask::new, () -> Icons.COLOR_HSB);
    public static final TaskType XP = TaskTypes.register(new ResourceLocation("ftbquests", "xp"), XPTask::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final TaskType DIMENSION = TaskTypes.register(new ResourceLocation("ftbquests", "dimension"), DimensionTask::new, () -> Icon.getIcon((String)"minecraft:block/nether_portal"));
    public static final TaskType STAT = TaskTypes.register(new ResourceLocation("ftbquests", "stat"), StatTask::new, () -> Icon.getIcon((String)"minecraft:item/iron_sword"));
    public static final TaskType KILL = TaskTypes.register(new ResourceLocation("ftbquests", "kill"), KillTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond_sword"));
    public static final TaskType LOCATION = TaskTypes.register(new ResourceLocation("ftbquests", "location"), LocationTask::new, () -> Icon.getIcon((String)"minecraft:item/compass_00"));
    public static final TaskType CHECKMARK = TaskTypes.register(new ResourceLocation("ftbquests", "checkmark"), CheckmarkTask::new, () -> Icons.ACCEPT_GRAY);
    public static final TaskType ADVANCEMENT = TaskTypes.register(new ResourceLocation("ftbquests", "advancement"), AdvancementTask::new, () -> Icon.getIcon((String)"minecraft:item/wheat"));
    public static final TaskType OBSERVATION = TaskTypes.register(new ResourceLocation("ftbquests", "observation"), ObservationTask::new, () -> Icons.ART);
    public static final TaskType BIOME = TaskTypes.register(new ResourceLocation("ftbquests", "biome"), BiomeTask::new, () -> Icon.getIcon((String)"minecraft:block/oak_sapling"));
    public static final TaskType STAGE = TaskTypes.register(new ResourceLocation("ftbquests", "gamestage"), StageTask::new, () -> Icons.CONTROLLER);

    public static TaskType register(ResourceLocation name, TaskType.Provider p, Supplier<Icon> i) {
        return TYPES.computeIfAbsent(name, id -> new TaskType((ResourceLocation)id, p, i));
    }

    public static void init() {
    }
}

